IF EXISTS (SELECT 1 FROM SYS.TRIGGERS WHERE NAME ='TRG_PDV_VD_INTEGRA_ZOOM' 
		  AND PARENT_ID =OBJECT_ID('PDV_VD'))
    BEGIN
	   DROP TRIGGER TRG_PDV_VD_INTEGRA_ZOOM;
    END
GO

CREATE TRIGGER TRG_PDV_VD_INTEGRA_ZOOM ON PDV_VD 
FOR INSERT,UPDATE 
AS 
     IF NOT UPDATE(ST_VD)
	   RETURN

	   BEGIN
		  INSERT INTO PDV_VD_INTEGRACAO_PENDENTE (CD_EMP,CD_FILIAL,CD_VD,STATUS,DT_CAD)
			 SELECT 
				CD_EMP,
				CD_FILIAL,
				CD_VD,
				0 AS [STATUS],
				GETDATE() AS DT_CAD
			 FROM 
				INSERTED
			 WHERE ST_VD <>1
			  
	   END

     
	   BEGIN
		  INSERT INTO PDV_VD_INTEGRACAO_CANCELAR_PENDENTE  (CD_EMP,CD_FILIAL,CD_VD,STATUS,DT_CAD)
			 SELECT 
				CD_EMP,
				CD_FILIAL,
				CD_VD,
				0 AS [STATUS],
				GETDATE() AS DT_CAD
			 FROM INSERTED
			 WHERE ST_VD =1
	   END
 
